"""
Przykład z podrozdziału "Programowanie asynchroniczne"
pokazujący, jak używać aiohttp do wykonywania
asynchronicznych wywołań HTTP.

"""
import asyncio
import time

import aiohttp

from asyncrates import get_rates

SYMBOLS = ("USD", "EUR", "PLN", "NOK", "CZK")
BASES = ("USD", "EUR", "PLN", "NOK", "CZK")


def present_result(base, rates):
    rates_line = ", ".join([f"{rates[symbol]:7.03} {symbol}" for symbol in SYMBOLS])
    print(f"1 {base} = {rates_line}")


async def main():
    async with aiohttp.ClientSession() as session:
        for result in await asyncio.gather(
            *[get_rates(session, base) for base in BASES]
        ):
            present_result(*result)


if __name__ == "__main__":
    started = time.time()
    loop = asyncio.get_event_loop()
    loop.run_until_complete(main())
    elapsed = time.time() - started

    print()
    print("Czas wykonywania: {:.2f}s".format(elapsed))
